package game;


import java.util.ArrayList;


public class BlockCollisionData {
	
	private ArrayList<SolidBlockSprite> collidedBlocks;
	
	private int leftVector;
	private int rightVector;
	private int upVector;
	private int downVector;
	
	private int leftBlocksAgree;
	private int rightBlocksAgree;
	private int upBlocksAgree;
	private int downBlocksAgree;
	
	private int leftBlocksRecommend;
	private int rightBlocksRecommend;
	private int upBlocksRecommend;
	private int downBlocksRecommend;
	
	private IntRect playerRect;
	
	private int playerXPos;
	private int playerYPos;
	
	private int playerRectMinX;
	private int playerRectMaxX;
	private int playerRectMinY;
	private int playerRectMaxY;
	
	public BlockCollisionData(CollidableObject player) {
		
		collidedBlocks = new ArrayList<SolidBlockSprite>();
		
		leftVector = 0;
		rightVector = 0;
		upVector = 0;
		downVector = 0;
		
		leftBlocksAgree = 0;
		rightBlocksAgree = 0;
		upBlocksAgree = 0;
		downBlocksAgree = 0;
		
		playerRect = player.getNextPosCollisionRect();
		playerXPos = player.getNextXPos();
		playerYPos = player.getNextYPos();
		playerRectMinX = (int) playerRect.getMinX();
		playerRectMinY = (int) playerRect.getMinY();
		playerRectMaxX = (int) playerRect.getMaxX();
		playerRectMaxY = (int) playerRect.getMaxY();
		
	}
	
	public void checkCollision(BlockInterface block) {
		
		IntRect blockRect = block.getCollisionRect();
		
		if(!playerRect.intersects(blockRect))
			return;
		
		//collidedBlocks.add(block);
		
		int newPotentialRightVector = 0;
		int newPotentialLeftVector = 0;
		int newPotentialUpVector = 0;
		int newPotentialDownVector = 0;
		
		if(block.getxPos() < playerXPos) {
			//block is to the left of the player; need to calculate the maximum distance we want to push the player
			newPotentialRightVector = Math.abs(playerRectMinX - (int) blockRect.getMaxX());
			if(newPotentialRightVector > rightVector)
				rightVector = newPotentialRightVector;
			rightBlocksAgree++;
		} else {
			//block is to the right of the player; need to calculate the maximum distance we want to push the player
			newPotentialLeftVector = Math.abs(playerRectMaxX - (int) blockRect.getMinX());
			if(newPotentialLeftVector > leftVector)
				leftVector = newPotentialLeftVector;
			leftBlocksAgree++;
		}
		
		
		if(block.getyPos() < playerYPos) {
			//block is above the player; need to calculate the maximum distance we want to push the player
			newPotentialDownVector = Math.abs(playerRectMinY - (int) blockRect.getMaxY());
			if(newPotentialDownVector > downVector)
				downVector = newPotentialDownVector;
			downBlocksAgree++;
		} else {
			//block is below the player; need to calculate the maximum distance we want to push the player
			newPotentialUpVector = Math.abs(playerRectMaxY - (int) blockRect.getMinY());
			if(newPotentialUpVector > upVector)
				upVector = newPotentialUpVector;
			upBlocksAgree++;
		}
		
		
		
		//now I need to decide which is better...
		if(newPotentialDownVector != 0) {
			if(newPotentialRightVector != 0) {
				//going down-right; which is better?
				
				if(newPotentialRightVector < newPotentialDownVector ) {
					rightBlocksRecommend++;
				} else {
					downBlocksRecommend++;
				}
				
			} else {
				//going down-left; which is better?
				

				if(newPotentialLeftVector < newPotentialDownVector ) {
					leftBlocksRecommend++;
				} else {
					downBlocksRecommend++;
				}
				
				
			}
		} else {
			if(newPotentialRightVector != 0) {
				//going down-right; which is better?
				
				if(newPotentialRightVector < newPotentialUpVector ) {
					rightBlocksRecommend++;
				} else {
					upBlocksRecommend++;
				}
				
			} else {
				//going down-left; which is better?
				

				if(newPotentialLeftVector < newPotentialUpVector ) {
					leftBlocksRecommend++;
				} else {
					upBlocksRecommend++;
				}
				
			}
		}
		
	}

	public int getLeftVector() {
		return leftVector;
	}

	public int getRightVector() {
		return rightVector;
	}

	public int getUpVector() {
		return upVector;
	}

	public int getDownVector() {
		return downVector;
	}

	public int getLeftBlocksAgree() {
		return leftBlocksAgree;
	}

	public int getRightBlocksAgree() {
		return rightBlocksAgree;
	}

	public int getUpBlocksAgree() {
		return upBlocksAgree;
	}

	public int getDownBlocksAgree() {
		return downBlocksAgree;
	}

	public int getLeftBlocksRecommend() {
		return leftBlocksRecommend;
	}

	public int getRightBlocksRecommend() {
		return rightBlocksRecommend;
	}

	public int getUpBlocksRecommend() {
		return upBlocksRecommend;
	}

	public int getDownBlocksRecommend() {
		return downBlocksRecommend;
	}
	
	
	
}
